'use strict';

/* --------------------------------------------------------------
 disable_edit_address_button.js 2020-06-16
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * Disables the order address edit button.
 */
(function () {
	'use strict';

	/**
  * Initializes the module.
  * 
  * @private
  */

	var init = function init() {
		var $links = $('.frame-head .head-link a');

		$links.each(function (index, link) {
			var $link = $(link);

			if (!$link.attr('href').includes('edit_action=address')) {
				return true;
			}

			$link.parent().append($('<span/>', {
				'text': $link.text().trim()
			})).css({
				'opacity': .6,
				'color': 'gray',
				'background': 'none',
				'cursor': 'not-allowed'
			});

			$link.remove();

			return false;
		});
	};

	EasyCreditHub.on('ready', function () {
		return init();
	});
})();
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
